<?php

function generate_config()
{
    include_once("../config/node_parameters.php");  /* DO NOT DELETE THIS LINE */ //All link parameters
    
    
return "
# JUNIPER Configuration on device IP: $IP
# ########################################################################## !!

##### Interface config ########################################################################################
set  interfaces ${INTERFACE_SRC} unit $SUBINTERFACE_SRC description $MAP_NAME
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet filter input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet filter output $MAP_NAME-OUT
#set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer arp ARP-LIMIT
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet policer output $MAP_NAME-OUT
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family inet address $IP_P2P_GATEWAY/$IP_P2P_MASK

##### IN filter  #####################################################################################
set  firewall filter $MAP_NAME-IN term T1 from destination-address $IP_P2P_GATEWAY/32
set  firewall filter $MAP_NAME-IN term T1 from protocol icmp
set  firewall filter $MAP_NAME-IN term T1 then accept

set  firewall filter $MAP_NAME-IN term T2 from source-address $IP_P2P
set  firewall filter $MAP_NAME-IN term T2 from destination-address $IP_P2P_GATEWAY/32
set  firewall filter $MAP_NAME-IN term T2 from protocol tcp
set  firewall filter $MAP_NAME-IN term T2 from port bgp
set  firewall filter $MAP_NAME-IN term T2 then accept
	
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 192.168.0.0/16
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 172.16.0.0/12
#set  firewall filter $MAP_NAME-IN term T3 from destination-address 10.0.0.0/8
#set  firewall filter $MAP_NAME-IN term T3 then discard
    
set  firewall filter $MAP_NAME-IN term T4 from source-address $IP_P2P
#set  firewall filter $MAP_NAME-IN term T4 from source-address $IP_PA
#set  firewall filter $MAP_NAME-IN term T4 from source-address $IP_PI
set  firewall filter $MAP_NAME-IN term T4 then dscp 0
set  firewall filter $MAP_NAME-IN term T4 then accept
    
set  firewall filter $MAP_NAME-IN term T5 then discard

##### OUT filter ############################################################################################
set  firewall filter $MAP_NAME-OUT term T1 from destination-address $IP_P2P
#set  firewall filter $MAP_NAME-OUT term T1 from destination-address $IP_PA
set  firewall filter $MAP_NAME-OUT term T1 from destination-address $IP_PI
set  firewall filter $MAP_NAME-OUT term T1 then accept
set  firewall filter $MAP_NAME-OUT term T2 then discard

    
#####Config standard (import) ###################################################################################################
set policy-options policy-statement $MAP_NAME-import term 1 from as-path as-path_$MAP_NAME
set policy-options policy-statement $MAP_NAME-import term 1 from prefix-list prefix_list_$MAP_NAME
set policy-options policy-statement $MAP_NAME-import term 1 then local-preference 300
set policy-options policy-statement $MAP_NAME-import term 1 then accept
set policy-options policy-statement $MAP_NAME-import term 2 then reject

##### Config DEFAULT ROUTE ONLY (export) ###################################################################################################
#set policy-options policy-statement $MAP_NAME-export term 1 from route-filter 0.0.0.0/0 exact
#set policy-options policy-statement $MAP_NAME-export term 1 then accept
#set policy-options policy-statement $MAP_NAME-export term default then reject
##### END Config DEFAULT ROUTE ONLY (export) ###################################################################################################

set policy-options policy-statement  ${$MAP_NAME}-export term 1 from community [ no-adv-any no-adv-peer-int ]
set policy-options policy-statement  ${$MAP_NAME}-export term 1 then reject
set policy-options policy-statement  ${$MAP_NAME}-export term 2 from protocol bgp
set policy-options policy-statement  ${$MAP_NAME}-export term 2 from as-path as_path_${$MAP_NAME}_out
set policy-options policy-statement  ${$MAP_NAME}-export term 2 then accept
set policy-options policy-statement  ${$MAP_NAME}-export term 3 then reject
##### END  DEFAULT ROUTE ONLY (export) ###################################################################################################
      
set policy-options prefix-list prefix_list_$MAP_NAME $IP_PI
set policy-options prefix-list prefix_list_$MAP_NAME $IP_PA

set policy-options as-path as_path_$MAP_NAME-in ^$AS(_$AS)*$
set policy-options as-path as_path_$MAP_NAME-out .*

set protocols bgp group BGP_$MAP_NAME type external
set protocols bgp group BGP_$MAP_NAME import $MAP_NAME-import
set protocols bgp group BGP_$MAP_NAME family inet unicast prefix-limit maximum [set prefix_list_max]
set protocols bgp group BGP_$MAP_NAME family inet unicast prefix-limit teardown 75
set protocols bgp group BGP_$MAP_NAME family inet unicast prefix-limit teardown idle-timeout forever
set protocols bgp group BGP_$MAP_NAME export $MAP_NAME-export
set protocols bgp group BGP_$MAP_NAME remove-private
set protocols bgp group BGP_$MAP_NAME peer-as $AS
#set protocols bgp group BGP_$MAP_NAME local-as [SET PRIV ASN] private
set protocols bgp group BGP_$MAP_NAME graceful-restart
set protocols bgp group BGP_$MAP_NAME neighbor $IP_P2P_CLIENT
	
##### Policers ##############################################################################################

set firewall policer $MAP_NAME-IN if-exceeding bandwidth-limit $UPLOAD
set firewall policer $MAP_NAME-IN if-exceeding burst-size-limit 10m
set firewall policer $MAP_NAME-IN then discard

set firewall policer $MAP_NAME-OUT if-exceeding bandwidth-limit $DOWNLOAD
set firewall policer $MAP_NAME-OUT if-exceeding burst-size-limit 10m
set firewall policer $MAP_NAME-OUT then discard

set firewall policer ARP-LIMIT if-exceeding bandwidth-limit 8k
set firewall policer ARP-LIMIT if-exceeding burst-size-limit 1500
set firewall policer ARP-LIMIT then discard
    
#set policy-options community no-adv-any members 21021:9000
#set policy-options community no-adv-any_p1_permit members 21021:9000
#set policy-options community no-adv-peer-ext members 21021:9100
#set policy-options community no-adv-peer-int members 21021:9200
#set policy-options community no-adv-peer-int_p1_permit members 21021:9200

";

    
    return $conf;
}
